/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CustomShapedRecipeBuilder
extends ShapedRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.func_200278_a();
    private String group;
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    public CustomShapedRecipeBuilder(IItemProvider result, int count) {
        super(result, count);
        this.result = result.func_199767_j();
        this.count = count;
    }

    public CustomShapedRecipeBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    private boolean hasCriteria() {
        return !this.advancement.func_200277_c().isEmpty();
    }

    public static CustomShapedRecipeBuilder shaped(IItemProvider item) {
        return CustomShapedRecipeBuilder.shaped(item, 1);
    }

    public static CustomShapedRecipeBuilder shaped(IItemProvider item, int count) {
        return new CustomShapedRecipeBuilder(item, count);
    }

    public CustomShapedRecipeBuilder define(Character character, ITag<Item> item) {
        return this.define(character, Ingredient.func_199805_a(item));
    }

    public CustomShapedRecipeBuilder define(Character character, IItemProvider item) {
        return this.define(character, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    public CustomShapedRecipeBuilder define(Character character, Ingredient item) {
        if (this.key.containsKey(character)) {
            throw new IllegalArgumentException("Symbol '" + character + "' is already defined!");
        }
        if (character.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(character, item);
        return this;
    }

    public CustomShapedRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public CustomShapedRecipeBuilder unlockedBy(String name, ICriterionInstance criteria) {
        this.advancement.func_200275_a(name, criteria);
        return this;
    }

    public CustomShapedRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public void func_200464_a(Consumer<IFinishedRecipe> consumer) {
        this.func_200467_a(consumer, Registry.field_212630_s.func_177774_c((Object)this.result));
    }

    public void func_200466_a(Consumer<IFinishedRecipe> consumer, String id) {
        ResourceLocation resourceLocation = Registry.field_212630_s.func_177774_c((Object)this.result);
        if (new ResourceLocation(id).equals((Object)resourceLocation)) {
            throw new IllegalStateException("Shaped Recipe " + id + " should remove its 'save' argument");
        }
        this.func_200467_a(consumer, new ResourceLocation(id));
    }

    public void func_200467_a(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        if (this.hasCriteria()) {
            this.advancement.func_200272_a(new ResourceLocation("simplyjetpacks", "root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        }
        consumer.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.rows, this.key, this.advancement));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;

        public Result(ResourceLocation id, Item result, @Nullable int count, String group, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder advancement) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.advancement = advancement;
        }

        public void func_218610_a(JsonObject jsonObject) {
            JsonArray patternArray = new JsonArray();
            for (String string : this.pattern) {
                patternArray.add(string);
            }
            jsonObject.add("pattern", (JsonElement)patternArray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().func_200304_c());
            }
            jsonObject.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject2.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)jsonObject2);
        }

        public JsonObject func_200441_a() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", Registry.field_218368_I.func_177774_c(this.func_218609_c()).toString());
            JsonArray conditionsArray = new JsonArray();
            if (!CustomShapedRecipeBuilder.this.conditions.isEmpty()) {
                for (ICondition condition : CustomShapedRecipeBuilder.this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonObject.add("conditions", (JsonElement)conditionsArray);
            }
            this.func_218610_a(jsonObject);
            return jsonObject;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222157_a;
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return CustomShapedRecipeBuilder.this.hasCriteria() ? this.advancement.func_200273_b() : null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return new ResourceLocation("simplyjetpacks", (this.group != null ? this.group : "") + this.id.func_110623_a());
        }
    }
}

